# -*- coding: utf-8 -*-
import os
os.chdir(r"D:\Documents(D)\Bellevue\1-Informatique\0 - Programme 2021\Semestre_3\3-IA\TP6 - Plus_court_chemin_Astar_INTERMEDIAIRE\Programmes\Enonce\Partie_3")

from graphviz import *
from numpy import inf
import matplotlib.pyplot as plt
import numpy as np
# import heapdict
from collections import deque
##############################################################################
#
# PARTIE 3
#
##############################################################################

#-----------------------------------------------------------------------------
# Matrice d'adjacence à partir de la lecture d'un fichier texte
# L'extension du fichier est requise dans la fonction
def mat_adj(fichier_texte):
    # Lecture du fichier texte
    with open(fichier_texte, 'r') as file :
        text=file.readlines()
    
    # Nombre de lignes dans le fichier texte, on retire 1 pour enlever la
    # première ligne qui ne contient que le nom des colonnes
    nb_lignes = len(text)-1
    
    # Création d'une liste contenant le nom des colonnes
    nom_colonne = text[0].split()
    nb_col = len(nom_colonne)
    # Taille de la matrice à écrire et définition de la matrice
    taille_matrice = nb_lignes*nb_col
    mat_adj = np.zeros((taille_matrice,taille_matrice))
    #-------------------------------------------------------------------------
    # Recherche des cases adjacentes  
    for l in range(nb_lignes-1):
        # On relève la ligne actuelle et on supprime son premier terme
        ligne_actuelle = text[l+1].split()
        ligne_actuelle = ligne_actuelle[1:]
        # On relève la ligne suivante et on supprime son premier terme
        ligne_suivante = text[l+2].split()
        ligne_suivante = ligne_suivante[1:]
        
        for c in range(nb_col-1):
            #-----------------------------------------------------------------
            # Traitement de la ligne actuelle, on regarde à droite si la valeur 
            # vaut 1, si c'est le cas la case est accessible
            if int(ligne_actuelle[c+1]) == 1 and int(ligne_actuelle[c]) != 0:
                mat_adj[nb_col*l+c][nb_col*l+c+1] =1
                # Symétrie de la matrice d'adjacence
                mat_adj[nb_col*l+c+1][nb_col*l+c] =1
            
            # On termine avec la dernière ligne
            if l == nb_lignes-2:
                if int(ligne_suivante[c+1]) == 1 and int(ligne_suivante[c]) != 0:
                    mat_adj[nb_col*(l+1)+c][nb_col*(l+1)+c+1] =1
                    # Symétrie de la matrice d'adjacence
                    mat_adj[nb_col*(l+1)+c+1][nb_col*(l+1)+c] =1
                    
            #---------------------------------------------------------
            # Traitement de la ligne suivante, on regarde si on a un 1 sur la 
            # ligne suivante pour un même numéro de colonne
            if int(ligne_suivante[c]) == 1 and int(ligne_actuelle[c]) != 0:
                mat_adj[nb_col*l+c][nb_col*(l+1)+c] =1
                # Symétrie de la matrice d'adjacence
                mat_adj[nb_col*(l+1)+c][nb_col*l+c] =1
                  
            # On termine avec la dernière colonne
            if c ==nb_col-2 and int(ligne_suivante[nb_col-1]) == 1 and int(ligne_actuelle[nb_col-1]) != 0:
                mat_adj[nb_col*l+nb_col-1][nb_col*(l+1)+nb_col-1] =1
                # Symétrie de la matrice d'adjacence
                mat_adj[nb_col*(l+1)+nb_col-1][nb_col*l+nb_col-1] =1
                
    return mat_adj

#-----------------------------------------------------------------------------
# Definition des étiquettes associées à chaque case à partir de la matrice
# d'adjacence 
def etiquettes(dictionnaire):
    # Initialisation de la matrice et de la numérotation
    matrice = []
    for noeud in dictionnaire.keys():
        matrice.append(noeud)
    return matrice


##############################################################################
##############################################################################

test = mat_adj("Test.prn")
print(test)