# Pour tracer des courbes

from matplotlib import pyplot as plt

#Pour lire des fichiers csv

import csv

#Pour faire les calculs

from math import sqrt, pi, sin, cos, atan, acos



#Ouverture du fichier csv

#fname='traj_rect.csv'

fname='traj_quelconque.csv'

file=open(fname)



#Déclaration des variables

tps=[]

tension1=[]

tension2=[]

intensite1=[]

intensite2=[]

force1=[]

force2=[]

vitesse1=[]

vitesse2=[]



try:

    reader=csv.reader(file,delimiter=',')

    for row in reader:

        tps.append(row[0]) #recupere la colonne 0 du csv

        tension1.append(row[33])

        tension2.append(row[34])

        intensite1.append(row[30])

        intensite2.append(row[31])

        force1.append(row[27])

        force2.append(row[28])

        vitesse1.append(row[21])

        vitesse2.append(row[22])



finally:

    file.close()



#on supprimer le nom des colonnes

tps=tps[1:]

tension1=tension1[1:]

tension2=tension2[1:]

intensite1=intensite1[1:]

intensite2=intensite2[1:]

force1=force1[1:]

force2=force2[1:]

vitesse1=vitesse1[1:]

vitesse2=vitesse2[1:]



#Calcul des puissances

pelec1=[]

pmeca1=[]

pelec2=[]

pmeca2=[]



for k in range(len(intensite1)):

    pelec1.append(float(intensite1[k])*float(tension1[k]))

    pmeca1.append(abs(float(force1[k])*float(vitesse1[k])*1e-3))

    pelec2.append(float(intensite2[k])*float(tension2[k]))

    pmeca2.append(abs(float(force2[k])*float(vitesse2[k])*1e-3))

    tps[k]=float(tps[k])



#calcul des énergies

def Energie(temps,puiss):

    nrj=0

    for k in range(len(temps)-1):

        nrj+=puiss[k]*(temps[k+1]-temps[k])

    return nrj



def Rendement(NrjE,NrjS):

    rdt=NrjS/NrjE*100

    return rdt



nrje1=Energie(tps,pelec1)

nrje2=Energie(tps,pelec2)

nrjm1=Energie(tps,pmeca1)

nrjm2=Energie(tps,pmeca2)





rdt1=Rendement(nrje1,nrjm1)

rdt2=Rendement(nrje2,nrjm2)



nrje=nrje1+nrje2

nrjm=nrjm1+nrjm2

rdtg=Rendement(nrje,nrjm)



print("Vérin1")

print("Energie électrique consommée",round(nrje1,2),"Joules")

print("soit un rendement de",round(rdt1,2),"%")

print("Vérin2")

print("Energie électrique consommée",round(nrje2,2),"Joules")

print("soit un rendement de",round(rdt2,2),"%")



print("###################")

print("# Energie globale #")

print("###################")

print("Energie consommé",round(nrje,2),"J, avec un rendement de",round(rdtg,2),"%.")



plt.plot(tps,pelec1)

plt.plot(tps,pmeca1)

plt.title("Puissance instantannée Vérin1")

plt.xlabel("Temps (s)")

plt.ylabel("Puissance (W)")

plt.legend(["Pelec", "Pmeca"])

plt.show()

plt.plot(tps,pelec2)

plt.plot(tps,pmeca2)

plt.title("Puissance instantannée Vérin2")

plt.xlabel("Temps (s)")

plt.ylabel("Puissance (W)")

plt.legend(["Pelec", "Pmeca"])

plt.show()

