function [U_discret] = Activite_03_GenerationEchelons(deltaT, nbEchelons, nbPasMin, nbPasMax, Umax)

%% Spcifications de la fonction
% Fonction permettant de gnrer des chelons d'une amplitude alatoire 
% (entre bornes) et de dure alatoire (entre bornes).
% On force une amplitude nulle pour le premier chelon. On ajoute un 
% chelon d'amplitude nulle pour le dernier chelon. (Il y a donc n+1
% chelons).

% Entres : 
%   * deltaT (double) : dure minimale d'un pas en seconde 
%                       (0.01s mini pour une carte Arduino);
%   * nbEchelons : nombre total d'chelons;
%   * nbPasMin : nombre de pas minimal d'un chelon (la dure mini est donc
%                de nbPasMin*deltaT);
%   * nbPasMax : nombre de pas maximal d'un chelon (la dure maxi est donc
%                de nbPasMax*deltaT);
%   * Umax (V) : tension maximale d'alimentation. On gnrera des signaux
%   entre +Umax et -Umax.

% Sorties 
%   Pour l'Arduino, on gnre des valeurs  chaque changement de PWM
%   * V : valeurs de PWM entre 0 et 255;
%   * S : valeurs des sens (O ou 1);
%   * tps : valeurs des temps ou le signal change;
%   Pour la comparaison modle-rel, on gnre les valeurs pour chaque
%   DeltaT
%   * temps_discret : temps discrtis  chaque deltaT;
%   * pwm_discret   : valeur du pmw  chaque deltaT;
%   * signe_discret : valeur du signe  chaque deltaT.




valeur(1) = 0 ; % Initialisation de la valeur du PWM
sens(1) = 0 ;   % Initialisation du sens (0 ou 1)
temps(1) = 0;   % Initialisation du temps


% Signaux discrtiss  chaque deltaT
temps_discret(1) = 0;
pwm_discret(1) = 0;
signe_discret(1) = 0;

for ii=1:1:nbEchelons
    % Tirage alatoire temps, valeur, signe
    tirage_temps = randi([nbPasMin, nbPasMax]) ;
    tirage_valeur = randi([-Umax, +Umax]); 
    signe = sign(tirage_valeur);
    
    % Ajout de la valeur de l'chelon, du temps et du sens
    valeur(2*ii) = valeur(2*ii-1);
    valeur(2*ii+1) = abs(tirage_valeur) ;
    
    sens(2*ii) = sens(2*ii-1);
    sens(2*ii+1) = signe;
    
    temps(2*ii)=temps(2*ii-1)+tirage_temps*deltaT;
    temps(2*ii+1)=temps(2*ii);
    
    
    % Ajout des valeurs de signaux pour chaque pas de temps
    fin = length(pwm_discret);
    for j=1:1:tirage_temps
        pwm_discret(fin+j)=valeur(2*ii-1);
        signe_discret(fin+j)=signe;
        temps_discret(fin+j)=deltaT*(fin+j-1);
    end
        
end

% Retour du PWM a 0
valeur(end)=0;
%pwm_discret(end+1)=0
fin = length(pwm_discret);

% Maintien  0 pendant nbPasMax*deltaT s
temps(end+1)=temps(end)+nbPasMax*deltaT;
valeur(end+1)=0;
sens(end+1)=sens(end);
for j=1:1:nbPasMax
        pwm_discret(fin+j)=0;
        signe_discret(fin+j)=0;
        temps_discret(fin+j)=temps_discret(fin)+j*deltaT;
end

% csvwrite("S.csv",sens');
% csvwrite("T.csv",temps');
% csvwrite("V.csv",valeur');
V = timeseries(valeur,temps) ;
S = timeseries(sens,temps) ;
pwm_signe_discret = signe_discret .* pwm_discret;
pwm_signe_discret = timeseries(pwm_signe_discret,temps_discret);

U_discret = pwm_signe_discret;
end





